/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.base.Optional;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.apiimpl.network.item.NetworkItemWirelessCraftingMonitor;
import com.raoulvdberge.refinedstorage.item.ItemNetworkItem;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWirelessCraftingMonitor
extends ItemNetworkItem
implements IBauble {
    public static final String NBT_TAB_SELECTED = "TabSelected";
    public static final String NBT_TAB_PAGE = "TabPage";

    public ItemWirelessCraftingMonitor() {
        super(new ItemInfo("refinedstorage", "wireless_crafting_monitor"), RS.INSTANCE.config.wirelessCraftingMonitorCapacity);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
    }

    @Override
    @Nonnull
    public INetworkItem provide(INetworkItemHandler handler, EntityPlayer player, ItemStack stack, int slotId) {
        return new NetworkItemWirelessCraftingMonitor(handler, player, stack, slotId);
    }

    public static Optional<UUID> getTabSelected(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(NBT_TAB_SELECTED)) {
            return Optional.of((Object)stack.func_77978_p().func_186857_a(NBT_TAB_SELECTED));
        }
        return Optional.absent();
    }

    public static void setTabSelected(ItemStack stack, Optional<UUID> tabSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (tabSelected.isPresent()) {
            stack.func_77978_p().func_186854_a(NBT_TAB_SELECTED, (UUID)tabSelected.get());
        } else {
            stack.func_77978_p().func_82580_o("TabSelectedLeast");
            stack.func_77978_p().func_82580_o("TabSelectedMost");
        }
    }

    public static int getTabPage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_TAB_PAGE)) {
            return stack.func_77978_p().func_74762_e(NBT_TAB_PAGE);
        }
        return 0;
    }

    public static void setTabPage(ItemStack stack, int tabPage) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(NBT_TAB_PAGE, tabPage);
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }
}

